package cn.com.duiba.kjy.livecenter.api.remoteservice.welfarerain;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.welfareRain.WelfareRainConfDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWelfareRainConfService {
    /**
     * 根据主键id来查询
     * @param id
     * @return
     */
    WelfareRainConfDto queryById(Long id);

    /**
     * 新增数据
     * @param WelfareRainConfDto
     * @return
     */
    Long insertConf(WelfareRainConfDto WelfareRainConfDto);

    /**
     * 修改数据
     * @param WelfareRainConfDto
     * @return 实例对象
     */
    int updateConf(WelfareRainConfDto WelfareRainConfDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);


    /**
     * 根据公司id查询
     * @param id
     * @return
     */
    List<WelfareRainConfDto> findByLiveId(Long id);

}
