package cn.com.duiba.kjy.livecenter.api.remoteservice.welfarerain;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.welfareRain.WelfareRainResultDto;
import cn.com.duiba.kjy.livecenter.api.enums.live.WelfareRainTypeEnum;

/**
 * @author chengsiyi
 * @date 2020/10/27 10:48
 */
@AdvancedFeignClient
public interface RemoteWelfareRainEventService {

    /**
     * 开始收集用户信息
     *
     * @param liveId 直播ID
     */
    void startCollect(Long liveId);

    /**
     * 开始计算用户
     *
     * @param liveId
     * @param confId
     */
    void compute(Long liveId, Long confId);

    /**
     * 访客抽取
     *
     * @param liveId 直播ID
     * @param confId 福利雨ID
     */
    WelfareRainResultDto draw(Long liveId, Long confId, Long liveUserId, WelfareRainTypeEnum welfareRainType);

    /**
     * 停止领取
     *
     * @param liveId 直播ID
     * @param confId 福利雨ID
     */
    void stopReceive(Long liveId, Long confId);

    /**
     * 补充马甲
     *
     * @param liveId 直播ID
     * @param confId 福利雨ID
     */
    void addVestAndEnd(Long liveId, Long confId);
}
