package cn.com.duiba.kjy.livecenter.api.dto.task;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @Author xujing
 * @Date 2020/11/10 4:11 下午
 */
@Data
public class TaskRecordDto implements Serializable {

    private static final long serialVersionUID = 4689794266758966479L;
    private Long id;

    /**
    * 任务id
    */
    private Long taskId;

    /**
    * 直播间id
    */
    private Long liveId;

    /**
    * 用户id
    */
    private Long liveUserId;

    /**
    * 奖励类型 1 抽奖券
    */
    private Integer rewardType;

    /**
    * 奖励数量
    */
    private Integer rewardNumber;

    /**
    * 直播间类型 1预告 2 直播
    */
    private Integer liveType;

    /**
    * 任务类型 1通用任务 2直播间定制任务
    */
    private Integer taskType;

    /**
    * 任务备注 json类型 比如抽奖券,可以将抽奖券具体的券码放进去
    */
    private String extraRemark;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 任务是否完成 1完成 0未完成
     */
    private Integer completed;
}