package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 直播间配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
@Getter
public enum LiveExtEnum {

    INVITE_COUNT(1, "代理人指定中奖参与条件,邀请个数"),

    CUSTOMER_SERVICE(2, "客服信息"),

    SHARE_POSTERS(3, "分享海报"),

    LIVE_WITCH_NUM(4,"直播结束后观看人数"),

    LIVE_VEST_WITCH_NUM(5,"小马甲人数操作记录"),

    LIVE_BOOM_BACKGROUND_IMG(6,"直播间爆款背景图"),

    RETAIN_RED_SHOW_PRICE(7,"停留红包展示金额"),

    LIVE_HALF_PRICE_INTERVAL_CONFIG(8,"直播间半价抽奖间隔时间配置"),

    LIVE_HALF_PRICE_PRIZE_NUM(9,"直播间半价抽奖单轮抽取人数配置"),

    LIVE_APPOINTMENT_POP_IMG(10,"直播间预约弹窗图片"),

    LIVE_NEWER_SPECIFY_GOODS(11,"直播间新人专享商品"),

    ;

    /**
     * 键  长度限制64
     */
    private Integer key;
    /**
     * 描述  长度限制1024
     */
    private String desc;


    LiveExtEnum(Integer key, String desc) {
        this.key = key;
        this.desc = desc;
    }


    private static final Map<Integer, LiveExtEnum> ENUM_MAP = new HashMap<>();



    static{
        for(LiveExtEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
    }

    public static LiveExtEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key){
        if (StringUtils.isBlank(key)){
            return false;
        }
        for (LiveExtEnum enumVal : LiveExtEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

}
