package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveVisitorInvitationDto;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveVisitorInvitationChangeParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveVisitorInvitationSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author zhanghuifeng
 * date 2020/4/4-3:13 下午
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorInvitationService {

    /**
     * 查询数量
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(LiveVisitorInvitationSearchParam param);

    /**
     * 获取用户当前直播间邀请人数（纯缓存，不走DB）
     * @param liveUserId
     * @param liveId
     * @return
     */
    @Deprecated
    long findInviteCountCache(Long liveUserId, Long liveId);

    /**
     * 获取用户当前直播间邀请人数
     * @param liveUserId 邀请人直播用户ID
     * @param liveId 直播ID
     * @return 邀请人数
     */
    long findInviteCount(Long liveUserId, Long liveId);

    /**
     * 查询用户的邀请记录
     * @param liveId
     * @param liveUserIds
     * @return
     */
    List<LiveVisitorInvitationDto> selectByLiveUserIds(Long liveId, Set<Long> liveUserIds);

    /**
     * 根据被邀请人ID查询该用户的被邀请记录
     * @param liveUserId 被邀请人ID
     * @param liveId 直播ID
     * @return 邀请关系
     */
    LiveVisitorInvitationDto selectByLiveUser(Long liveId, Long liveUserId);
    /**
     * 统计邀请人邀请了多少人数
     * @param liveId 直播id
     * @param inviterIds 邀请人id集合
     * @return key：邀请人id value：邀请人邀请的人数
     */
    Map<Long, Long> countInviterHasNum(Long liveId, Set<Long> inviterIds);

    /**
     * 获取邀请人邀请列表
     *
     * @param liveId     直播ID
     * @param inviterIds 邀请人ID
     * @param channelId  邀请渠道，{@link cn.com.duiba.kjy.livecenter.api.enums.live.LiveInviteChannelEnum }
     *                   null表示全渠道
     * @return Map:邀请人，邀请列表
     */
    Map<Long, List<LiveVisitorInvitationDto>> findByLiveIdAndInvitorIds(Long liveId, List<Long> inviterIds, Integer channelId);

    /**
     * 获取用户邀请列表
     *
     * @param liveId    直播ID
     * @param inviterId 邀请人ID
     * @param channelId 邀请渠道，{@link cn.com.duiba.kjy.livecenter.api.enums.live.LiveInviteChannelEnum }
     *                  null表示全渠道
     * @return 邀请列表
     */
    List<LiveVisitorInvitationDto> findUserInviteList(Long liveId, Long inviterId, Integer channelId);

    /**
     * @param param 更新参数
     * @return 返回结果
     */
    Integer updateUserChannel(LiveVisitorInvitationChangeParam param);
}
