package cn.com.duiba.kjy.livecenter.api.dto.black;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播黑名单来源用户任务bean
 * @author 吴文哲
 * @date 2020-09-29 17:43
 **/
@Data
public class LiveBlackSourceUserTaskBean implements Serializable {
    private static final long serialVersionUID = -2279464046393974751L;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 黑名单来源用户列表
     */
    private List<LiveBlackSourceDto> blackSourceDtoList;

    /**
     * 来源类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.blackList.SourceTypeEnum
     */
    private Integer sourceType;
}
