package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveUserClueEsDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveUserEsQueryParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 直播用户线索es接口
 * @author 吴文哲
 * @date 2020-09-22 11:07
 **/
@AdvancedFeignClient
public interface RemoteLiveUserClueEsService {


    /**
     * 根据条件统计数量
     * @param param 查询条件
     * @return 统计总数
     */
    long countByCondition(LiveUserEsQueryParam param);


    /**
     * 根据条件查询用户线索列表
     * @param param 查询参数
     * @return key: 当前页数量 val:当前页用户线索列表
     *
     */
    Pair<Long, List<LiveUserClueEsDto>> findByCondition(LiveUserEsQueryParam param);
}
