package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveBoomGoodsDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/5/17 10:41
 */
@AdvancedFeignClient
public interface RemoteLiveBoomGoodsService {

    /**
     * 保存爆款商品
     * @param liveId 直播ID
     * @param goods 商品信息
     * @return
     */
    int saveGoods(Long liveId, List<LiveBoomGoodsDto> goods);

    int updateById(LiveBoomGoodsDto dto);

    LiveBoomGoodsDto getById(Long id);

    /**
     * 获取直播间爆款商品
     * @param liveId 直播间ID
     * @return 商品
     */
    List<LiveBoomGoodsDto> getByLiveId(Long liveId);

    /**
     * 根据liveId查询5件爆款商品
     * @param liveId
     * @return
     */
    List<LiveBoomGoodsDto> getByLiveIdLimit5(Long liveId);

    /**
     * 扣商品库存
     *
     * @param liveId  直播间ID
     * @param goodsId 商品ID
     * @return
     */
    Boolean reduceOneStock(Long liveId, Long goodsId);

    /**
     * 扣商品虚拟库存
     *
     * @param liveId  直播间ID
     * @param goodsId 商品ID
     * @return
     */
    Boolean reduceOneVirtualStock(Long liveId, Long goodsId);
}
