package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveUserBehaviorDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveUserBehaviorParam;

import java.util.List;

/**
 * 直播用户行为
 * @author ouyang
 * @date 2021/9/28
 */
@AdvancedFeignClient
public interface RemoteLiveUserBehaviorService {



    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播用户行为
     */
    LiveUserBehaviorDto selectById(Long id);

    /**
     * 根据查询参数查询用户行为列表
     * @param param 查询参数
     * @return 直播用户行为列表
     */
    List<LiveUserBehaviorDto> selectByParam(LiveUserBehaviorParam param);

    /**
     * 新增/编辑
     * @param dto 用户行为
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveUserBehaviorDto dto);

    /**
     * 删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

}
