package cn.com.duiba.kjy.livecenter.api.remoteservice.resources;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveResource.CommodityListDto;

import java.util.List;

/**
 * 商品清单
 * @Author xujing
 * @Date 2021/6/25 2:06 下午
 */
@AdvancedFeignClient
public interface RemoteCommodityListService {
    /**
     * 插入一条商品清单
     * @param dto
     * @return
     */
    Long insert(CommodityListDto dto);


    /**
     * 更新一条商品清单
     * @param dto
     * @return
     */
    Integer update(CommodityListDto dto);


    /**
     * 删除一条商品清单
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据直播间id查询商品清单列表
     * @param liveId
     * @return
     */
    List<CommodityListDto> listByLiveId(Long liveId);

    /**
     * 查询单个商品清单
     * @param id
     * @return
     */
    CommodityListDto findById(Long id);

    /**
     * 查询商品清单绑定的直播间的配置id数量
     *
     * @param ids
     * @return
     */
    Integer countByParam(List<Long> ids);

    /**
     * 批量插入
     * @param list
     * @return
     */
    int insertList(List<CommodityListDto> list);

    /**
     * 根据ids删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据直播间id删除
     * @param liveId
     * @return
     */
    Integer deleteByLiveId(Long liveId);


}
