package cn.com.duiba.kjy.livecenter.api.remoteservice.creditCard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.CreditCardApplyOrderDto;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.CreditCardLinkConfNumDto;
import cn.com.duiba.kjy.livecenter.api.param.creditCard.CreditCardApplyOrderSearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/7/12 3:46 下午
 */
@AdvancedFeignClient
public interface RemoteCreditCardApplyOrderService {
    /**
     * 批量查询链接对应的进件数量
     * @param confIds
     * @return
     */
    List<CreditCardLinkConfNumDto> countSuccessByConfIds(List<Long> confIds);

    /**
     * 新增一条记录
     * @param dto
     * @return
     */
    Long save(CreditCardApplyOrderDto dto);

    /**
     * 更新数据
     * @param dto
     * @return
     */
    Integer update(CreditCardApplyOrderDto dto);

    /**
     * 查询数量
     * @return
     */
    Long countByParam(CreditCardApplyOrderSearchParam param);

    /**
     * 分页查询
     * @return
     */
    List<CreditCardApplyOrderDto> pageByParam(CreditCardApplyOrderSearchParam param);


    /**
     * 根据id查询
     * @param id
     * @return
     */
    CreditCardApplyOrderDto findById(Long id);


    /**
     * 根据订单号查询
     * @param orderNum
     * @return
     */
    CreditCardApplyOrderDto findByOrderNum(String orderNum);
}
