package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAgentDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.TeamStaticsDto;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsTeamDto;
import cn.com.duiba.kjy.livecenter.api.param.statistics.LiveStatisticsTeamSearchParam;

import java.util.List;

/**
 * 团队纬度直播数据统计rpc服务
 * @author 吴文哲
 * @date 2020-03-30 15:52
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsTeamService {

    /**
     * 根据直播间id 团队id 获取统计数据
     * @param liveId
     * @param teamId
     * @return
     */
    LiveStatisticsTeamDto getByLiveIdAndTeamId(Long liveId,Long teamId);


    /**
     * 根据条件获取对应直播间 团队纬度统计数据
     * @param param
     * @return
     */
    List<LiveStatisticsTeamDto> getListByCondition(LiveStatisticsTeamSearchParam param);

    /**
     * 获取团队排名
     * 不同直播间状态 统计数据不同
     * @param liveId 直播间id
     * @param teamId 代理人id
     * @return
     */
    Integer getTeamRanking(Long liveId,Long teamId);

    /**
     * 获取团队排名
     * 不同直播间状态 统计数据不同
     * @param liveId 直播间id
     * @param teamId 代理人id
     * @return
     */
    Integer getTeamRankingNew(Long liveId,Long teamId,Boolean appointment);

    /**
     * 增量跟新统计数据
     * @param liveId
     * @param teamStaticsBeanList
     * @return
     */
    Integer batchUpdateInvitationAndPresentNum(Long liveId, List<TeamStaticsDto> teamStaticsBeanList);

    /**
     * 新增某次直播某个团队的到场人数
     * @param liveId 直播ID
     * @param liveAgentDto 新增数量来自哪个代理人
     * @return 新增数量> 0 新增成功
     */
    Integer atomicIncreasePresentNum(Long liveId, LiveAgentDto liveAgentDto);

    /**
     * 新增某次直播某个团队的到场人数
     * @param liveId 直播ID
     * @param liveAgentDto 新增数量来自哪个代理人
     * @return 新增数量> 0 新增成功
     */
    Integer atomicIncreaseAppointmentNum(Long liveId, LiveAgentDto liveAgentDto);
}
