package cn.com.duiba.kjy.livecenter.api.dto.cardLibrary;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播间卡券预扣库存表
 *
 * @Author xujing
 * @Date 2021/3/3 5:26 下午
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CardPreStockDto implements Serializable {

    private static final long serialVersionUID = -2036538598213724222L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 剩余库存
     */
    private Long remainStock;

    /**
     * 总库存
     */
    private Long totalStock;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 卡券库id
     */
    private Long cardLibraryId;

    /**
     * 直播配置表id
     * tb_live_interact_conf.id
     */
    private Long interactConfId;
}