package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author xujing
 * @Date 2021/6/25 5:03 下午
 */
@Getter
public enum ResourceLocationJumpPageEnum {
    WELFARE(1,"免费福利"),
    ;


    private Integer type;

    private String desc;

    ResourceLocationJumpPageEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ResourceLocationJumpPageEnum> ENUM_MAP = new HashMap<>();


    static {
        for (ResourceLocationJumpPageEnum applyCardTypeEnum : values()) {
            ENUM_MAP.put(applyCardTypeEnum.getType(), applyCardTypeEnum);
        }
    }

    public static ResourceLocationJumpPageEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (ResourceLocationJumpPageEnum enumVal : ResourceLocationJumpPageEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }
}
