package cn.com.duiba.kjy.livecenter.api.param.creditCard;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * @Author xujing
 * @Date 2021/7/12 4:00 下午
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class CreditCardApplyOrderSearchParam extends PageQuery {

    private static final long serialVersionUID = -2434050719069588998L;

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 链接id
     */
    private Long cardConfId;

    /**
     * 进件开始时间
     */
    private Date applyStart;

    /**
     * 进件结束时间
     */
    private Date applyEnd;

    private Integer status;

    /**
     * 用户id集合
     */
    private List<Long> userIds;

    /**
     * 公司id集合
     */
    private List<Long> companyIds;
}
