package cn.com.duiba.kjy.livecenter.api.param.live;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 用户预约表
 * @author kjj mybatis generator 
 * @date 2020-04-05
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class LiveUserAppointmentSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15860583566068021L;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 直播userId
     */
    private Long liveUserId;

    /**
     * 业务类型，1、直播间ID，2直播间奖励配置ID
     */
    private Integer bizType;

    /**
     * 直播用户id列表
     */
    private List<Long> liveUserIds;

    /**
     * 预约标识
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.UserAppointmentFlagEnum
     */
    private Integer appointmentFlag;
}