package cn.com.duiba.kjy.livecenter.api.enums.creditCard;

import lombok.Getter;

import java.util.Objects;

/**
 * @author chenhang
 * @date 2021/9/29 4:07 下午
 */
@Getter
public enum CardHolderTypeEnum {
    CARD_HOLDER_NBCB(1, "宁波银行"),
    CARD_HOLDER_CITIC(2, "中信银行"),
    CARD_HOLDER_CMB(3, "招商银行");
    /**
     * 场景类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String decs;

    CardHolderTypeEnum(Integer type, String desc) {
        this.type = type;
        this.decs = desc;
    }

    public static CardHolderTypeEnum getByType(Integer type) {
        for (CardHolderTypeEnum typeEnum : CardHolderTypeEnum.values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
