package cn.com.duiba.kjy.livecenter.api.dto.smallshop.order;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: fss
 * @Date: 2021/9/7 16
 * @Description:
 */
@Data
public class RefundInfoDto implements Serializable {
    private static final long serialVersionUID = 7678654731641294613L;

    /**
     * 标识这个sku是否可发起商品退款
     */
    @JSONField(name = "can_refund")
    private String canRefund;


    /**
     * 退款商品金额
     */
    @JSONField(name = "refund_item_fee")
    private String refundItemFee;

    /**
     * 状态描述
     */
    @JSONField(name = "refund_status_desc")
    private String refundStatusDesc;


    /**
     * 退款金额
     */
    @JSONField(name = "refund_fee")
    private String refundFee;
    /**
     * 商品退款运费金额
     */
    @JSONField(name = "refund_express_fee")
    private String refundExpressFee;


    /**
     * 商品id
     */
    @JSONField(name = "item_id")
    private String itemId;

    /**
     * 退款状态， 0或空值 未发起退款；1 申请退款或退款；3 拒绝退款；4 退货流程同意退货；5 退货流程拒绝退货；6 退货流程已提交退货物流信息；9 退款取消；10 退款完成（同意退款或收到退货后同意退款，退款流程完成，资金流程开始）
     */
    @JSONField(name = "refund_status")
    private String refundStatus;


    /**
     * 状态描述
     */
    @JSONField(name = "refund_status_str")
    private String refundStatusStr;
    /**
     * 退款唯一标识
     */
    @JSONField(name = "refund_no")
    private String refundNo;


    /**
     * sku ID
     */
    @JSONField(name = "item_sku_id")
    private String itemSkuId;

    /**
     * 退款类型，1表示退款，2表示退货退款，3表示换货
     */
    @JSONField(name = "refund_kind")
    private String refundKind;
}
