package cn.com.duiba.kjy.livecenter.api.remoteservice.creditCard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.CreditCardApplyOrderDto;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.CreditCardLinkConfDto;
import cn.com.duiba.kjy.livecenter.api.param.creditCard.CreditCardLinkConfSearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/7/12 3:47 下午
 */
@AdvancedFeignClient
public interface RemoteCreditCardLinkConfService {
    /**
     * 查询单条详情
     * @param id
     * @return
     */
    CreditCardLinkConfDto findById(Long id);

    /**
     * 删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 保存
     * @param creditCardLinkConfDto
     * @return
     */
    Long save(CreditCardLinkConfDto creditCardLinkConfDto);

    /**
     * 更新
     * @param creditCardLinkConfDto
     * @return
     */
    Integer update(CreditCardLinkConfDto creditCardLinkConfDto);

    /**
     * 查询数量
     * @param param
     * @return
     */
    Long countByParam(CreditCardLinkConfSearchParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<CreditCardLinkConfDto> pageByParam(CreditCardLinkConfSearchParam param);


    /**
     * 根据ids查询
     * @param ids
     * @return
     */
    List<CreditCardLinkConfDto> findByIds(List<Long> ids);
}
