package cn.com.duiba.kjy.livecenter.api.remoteservice.homepage;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.homepage.CompanyHomeDto;
import cn.com.duiba.kjy.livecenter.api.param.homepage.HomePageSearchParam;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/9/9 16:37
 */
@AdvancedFeignClient
public interface RemoteCompanyHomeService {

    /**
     * 保存
     * @param dto
     * companyId pageDetail topTitleImg
     * @return ID
     */
    Long save(CompanyHomeDto dto);

    /**
     * 更新
     * @param dto
     * @return 更新结果
     */
    Long updateById(CompanyHomeDto dto);

    /**
     * 通过ID查询
     * @param id ID
     * @return
     */
    CompanyHomeDto getById(Long id);

    /**
     * 分页查询，注意不返回 pageDetail
     *
     * @param param 查询参数
     * @return
     */
    List<CompanyHomeDto> pageList(HomePageSearchParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return
     */
    Long selectCount(HomePageSearchParam param);

    /**
     * 查询参数列表
     *
     * @param param 查询参数
     * @return
     */
    List<CompanyHomeDto> getList(HomePageSearchParam param);

}
