package cn.com.duiba.kjy.livecenter.api.dto.creditCard;

import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderStatusEnum;
import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author chenhang
 * @date 2021/9/29 3:30 下午
 */
@Data
public class UserCardHolderDto  implements Serializable {
    private static final long serialVersionUID = 4519979933721501893L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * @see CardHolderTypeEnum
     * @see CardHolderStatusEnum
     * @see CardHolderTypeEnum
     * 用户持卡信息  [{"cardHolderType":"","cardHolderStatus":"","consumeStatus":""}]
     */
    private String cardHolderInfo;

    /**
     * 用户持卡信息列表
     */
    private List<CardHolderInfoDto> cardHolderInfoList;

    /**
     * 手机号
     */
    private String phoneNum;

    public List<CardHolderInfoDto> getCardHolderInfoList() {
        if(StringUtils.isEmpty(cardHolderInfo)){
            return new ArrayList<>();
        }
       return JSON.parseArray(cardHolderInfo, CardHolderInfoDto.class);
    }
}
