package cn.com.duiba.kjy.livecenter.api.dto.live;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播代理人小程序二维码表
 * @author kjj mybatis generator 
 * @date 2020-04-11
 */
@Data
public class LiveAgentQrCodeDto implements Serializable {

    /**
     * 拓展字段短链Id
     */
    public static final String CODE_KEY="shortUrlCode";
    /**
     * 拓展字段url
     */
    public static final String URL_KEY="mpQrcodeUrl";
     
    private static final long serialVersionUID = 1586593474396944L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 代理人所在公司id
     */
    private Long companyId;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 短链code
     */
    private String shortUrlCode;

    /**
     * 小程序二维码地址
     */
    private String mpQrcodeUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 拓展字段
     */
    private String extraJson;

    /**
     * 日志父级分类(用于区分海报位置）
     */
    private Integer logCate;

    /**
     * 日志子级分类(用于区分海报位置）
     */
    private Integer logSubCate;
}