package cn.com.duiba.kjy.livecenter.api.dto.live.goods;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by hong
 * time 2021/6/4.
 */
@Data
public class LiveGoodsSalesDto implements Serializable {

    private static final long serialVersionUID = 5546140498983600479L;

    /**
     * 主键
     * not null default = null
     */
    private Long id;

    /**
     * 直播ID
     * not null default = 0
     */
    private Long liveId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 销量
     * not null default = 0
     */
    private Integer goodsSales;

    /**
     * 价格
     */
    private BigDecimal goodsPrice;

    /**
     * 爬取时间
     * max length = 50
     */
    private String crawlTime;

    /**
     * 商品id
     * not null default = 0
     */
    private Long confId;

    /**
     * 初始销量
     * not null default = 0
     */
    private Integer initialSales;
}
