package cn.com.duiba.kjy.livecenter.api.enums.live.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * 消息配置的标记
 * kjy-center: cn.com.duiba.kjy.api.enums.MessageMarkEnum
 *
 * @author xuzhigang
 * @date 2020/8/3 4:34 下午
 **/
@Getter
@AllArgsConstructor
public enum MessageMarkEnum {
    LIVE_USER_APPOINTMENT(140, "直播开播用户订阅消息"),
    LIVE_USER_DRAW(141, "访客领取权益订阅消息推送"),
    LIVE_USER_APPOINTMENT_LOTTERY(142, "直播预约活动开奖通知"),
    LIVE_USER_APPOINTMENT_RED(143, "直播预约红包领取通知"),
    LIVE_USER_NEXT_APPOINTMENT(144, "下场直播开播用户订阅消息"),
    OFFER_PRIZES(147, "邀约有奖订阅消息"),
    ;

    /**
     * markId
     */
    private Integer mark;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据mark获取枚举
     *
     * @param mark markId
     * @return MessageMarkEnum
     */
    public static MessageMarkEnum getMessageMarkEnumByMark(Integer mark) {
        return Arrays.stream(values()).filter(messageMarkEnum -> Objects.equals(mark, messageMarkEnum.getMark()))
                .findFirst()
                .orElse(null);
    }
}
