package cn.com.duiba.kjy.livecenter.api.enums.live.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播推送类型，对应 cn.com.duiba.kjy.api.enums.push.PushEventEnum
 * @author lizhi
 * @date 2020/7/23 10:40 AM
 */
@Getter
@AllArgsConstructor
public enum PushTypeEnum {

    //对应 cn.com.duiba.kjy.api.enums.push.PushEventEnum
    L5(1, "开播提醒"),

    L17(2, "活动开奖通知"),

    L18(3, "红包领取通知"),

    L19(4, "下场开播提醒"),

    L29(5, "邀约有奖推送"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    private static final Map<Integer, PushTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (PushTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static PushTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
