package cn.com.duiba.kjy.livecenter.api.enums.live.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author xujing
 * @date 2020/12/04 11:33
 */
@Getter
@AllArgsConstructor
public enum CouponIssueActionEnum {
    ENTER(1, "进入直播间30s"),
    ATTENTION(2, "关注直播间"),
    ENTER_AT_ONCE(3,"一进入直播间立即请求")
    ;

    public static final List<Integer> ENTER_ACTION = new ArrayList<>();
    public static final List<Integer> ATTENTION_ACTION = new ArrayList<>();
    public static final List<Integer> ENTER_AT_ONCE_ACTION = new ArrayList<>();

    static {
        ENTER_ACTION.add(CouponIssueUserEnum.ENTER.getType());
        ENTER_ACTION.add(CouponIssueUserEnum.NO_CONSUME.getType());
        ATTENTION_ACTION.add(CouponIssueUserEnum.ATTENTION.getType());
        ENTER_AT_ONCE_ACTION.add(CouponIssueUserEnum.AGENT_DIRECT_INVITE.getType());
        ENTER_AT_ONCE_ACTION.add(CouponIssueUserEnum.NO_AGENT_DIRECT_INVITE.getType());
        ENTER_AT_ONCE_ACTION.add(CouponIssueUserEnum.AGENT_DIRECT_INVITE_NO_CARD_NO_CONSUME.getType());
        ENTER_AT_ONCE_ACTION.add(CouponIssueUserEnum.NO_AGENT_DIRECT_INVITE_NO_CARD_NO_CONSUME.getType());
    }
    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据type获取枚举
     *
     * @param type markId
     * @return MessageMarkEnum
     */
    public static CouponIssueActionEnum getByType(Integer type) {
        return Arrays.stream(values()).filter(couponIssueLocationEnum -> Objects.equals(type, couponIssueLocationEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
