package cn.com.duiba.kjy.livecenter.api.enums.subscribe;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2021/12/18.
 */
@Getter
public enum MessagePushTypeEnum {

    COUPON_USAGE_REMINDER(1, "couponUsageReminder", "优惠券使用提醒");

    private final Integer code;

    private final String  type;

    private final String  desc;

    MessagePushTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static MessagePushTypeEnum getByCode(Integer code) {
        return Stream.of(MessagePushTypeEnum.values())
                     .filter(e -> e.getCode()
                                   .equals(code))
                     .findFirst()
                     .orElse(COUPON_USAGE_REMINDER);
    }

    public static MessagePushTypeEnum getByType(String type) {
        return Stream.of(MessagePushTypeEnum.values())
                     .filter(e -> e.getType()
                                   .equals(type))
                     .findFirst()
                     .orElse(COUPON_USAGE_REMINDER);
    }
}