package cn.com.duiba.kjy.livecenter.api.remoteservice.smallshop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.smallshop.SyncOrderDto;
import cn.com.duiba.kjy.livecenter.api.dto.smallshop.TaskHandlerDto;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/9/7 17
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteShopAuthorizeService {

    /**
     * 根据店铺id获取授权链接
     *
     * @param openid
     * @return
     */
    String getAccessToken(String openid);

    /**
     * 刷新accessToken
     * @param openid
     * @return
     */
    String refreshAccessToken(String openid);

    /**
     * 获取授权的链接URL
     *
     * @param redirectUri
     * @return
     */
    String getAuthorizeUrl(String redirectUri);

    /**
     * 根据code查询token数据并保存
     *
     * @param code
     * @return
     */
    Boolean saveAccessTokenRecord(String code);

    /**
     * 同步订单信息
     *
     * @param syncOrderDto 入参
     * @return
     */
    Boolean syncOrderInfo(SyncOrderDto syncOrderDto);


    /******* 定时任务接口 ******/

    /**
     * 定时任务获取需刷新列表
     *
     * @return
     */
    List<String> getTokenSetList();

    /**
     * 刷新refreshToken过期时间
     *
     * @param openid
     * @return 更新时间
     */
    TaskHandlerDto updateRefreshTokenExpireTime(String openid);

}
