package cn.com.duiba.kjy.livecenter.api.enums.conf;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author xujing
 * @Date 2021/6/25 5:03 下午
 */
@Getter
public enum ResourceLocationConfTypeEnum {
    BOOKING_PAGE(1,"预约页"),
    ;


    private Integer type;

    private String desc;

    ResourceLocationConfTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, ResourceLocationConfTypeEnum> ENUM_MAP = new HashMap<>();


    static {
        for (ResourceLocationConfTypeEnum applyCardTypeEnum : values()) {
            ENUM_MAP.put(applyCardTypeEnum.getType(), applyCardTypeEnum);
        }
    }

    public static ResourceLocationConfTypeEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (ResourceLocationConfTypeEnum enumVal : ResourceLocationConfTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }
}
