package cn.com.duiba.kjy.livecenter.api.enums.live.coupon;

import java.util.Arrays;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 券码类型 1-通用券 2-单品券（只针对某一商品）
 * @author ouyang
 * @date 2022/03/14 11:33
 */
@Getter
@AllArgsConstructor
public enum CouponIssueTypeEnum {
    UNIVERSAL(1, "通用券"),
    INDIVIDUAL_PRODUCT(2, "单品券"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 根据type获取枚举
     *
     * @param type markId
     * @return MessageMarkEnum
     */
    public static CouponIssueTypeEnum getByType(Integer type) {
        return Arrays.stream(values()).filter(couponIssueLocationEnum -> Objects.equals(type, couponIssueLocationEnum.getType()))
                .findFirst()
                .orElse(null);
    }
}
