package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueRewardDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueRewardVisitorIdDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveUserRewardCountDto;
import cn.com.duiba.kjy.livecenter.api.dto.form.FormRecordDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveCLueRewardFindParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardConsumerParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardPageParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueRewardSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 直播线索-奖励领取记录remote
 * @author zhanghuifeng
 * date 2020/4/3-9:17 下午
 */
@AdvancedFeignClient
public interface RemoteLiveClueRewardService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播线索-奖励领取记录
     */
    LiveClueRewardDto findById(Long id);

    /**
     * 新增
     * @param dto 直播线索-奖励领取记录
     * @return 执行结果
     */
    Boolean add(LiveClueRewardDto dto);

    /**
     * 新增
     * @param dto 直播线索-奖励领取记录
     * @return 执行结果
     */
    Long insert(LiveClueRewardDto dto);

    Boolean updateById(LiveClueRewardDto dto);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveClueRewardSearchParam param);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播线索-奖励领取记录集合
     */
    List<LiveClueRewardDto> selectPage(LiveClueRewardSearchParam param);

    /**
     * 分页查询
     * @param pageParam
     * @return
     * @deprecated 请使用 selectPage
     */
    @Deprecated
    Page<LiveClueRewardDto> page(LiveClueRewardPageParam pageParam);

    /**
     * 根据直播间ID、用户ID、权益ID集合查询每个权益领取数量
     * @param liveId
     * @param liveVisitorId
     * @param rewardIds
     * @return
     */
    List<LiveUserRewardCountDto> findCountByLiveAndUserAndRewardIds(Long liveId, Long liveVisitorId, List<Long> rewardIds,
                                                                    List<Integer> rewardTypes);

    /**
     * 查询一个用户的领取记录（自动判断是否只能抽奖一次）
     * @param param 直播+福利ID+福利类型+用户ID
     * @return 领取记录
     */
    LiveClueRewardDto findUserReceiveRecordNew(LiveCLueRewardFindParam param);

    /**
     * 查询一个用户的领取记录
     * @param param 直播+福利ID+福利类型+用户ID 组成的唯一索引
     * @return 领取记录
     * @deprecated 请使用 findUserReceiveRecordNew
     */
    @Deprecated
    LiveClueRewardDto findUserReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 查询一个用户的爆款领取记录
     * @param param 直播+用户ID （爆款福利一场直播只能领取一次）
     * @return 爆款福利
     * @deprecated 请使用 findUserReceiveRecordNew
     */
    @Deprecated
    LiveClueRewardDto findUserBoomReceiveRecord(LiveCLueRewardFindParam param);

    /**
     * 批量查询用户领取数量（自动判断是否只能抽奖一次）
     * @param liveId 直播ID
     * @param rewardType 福利类型，可为空
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum
     * @param liveVisitorIdList 直播用户ID集合
     * @param confId 直播互动配置id
     * @return key：用户ID，value：领取数量
     */
    Map<Long, Long> findUserReceiveCountNew(Long liveId, Integer rewardType, List<Long> liveVisitorIdList, Long confId);

    /**
     * 批量查询用户领取数量
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @param confId 直播互动配置id
     * @return key：用户ID，value：领取数量
     * @deprecated 请使用 findUserReceiveCountNew
     */
    @Deprecated
    Map<Long, Long> findUsersReceiveCount(Long liveId, List<Long> liveVisitorIdList, Long confId);

    /**
     * 批量查询用户爆款福利领取数量
     * @param liveId 直播id
     * @param liveVisitorIdList 直播用户ID集合
     * @param rewardType 福利类型
     * @return key：用户ID，value：领取数量
     * @deprecated 请使用 findUserReceiveCountNew
     */
    @Deprecated
    Map<Long, Long> findUsersBoomReceiveCount(Long liveId, List<Long> liveVisitorIdList, Integer rewardType);

    /**
     * 查询福利领取数量
     * @param rewardIdList 福利ID集合
     * @return 福利领取数量
     */
    Map<Long, Long> findRewardCount(List<Long> rewardIdList);

    /**
     * 查询福利领取数量
     * @param rewardIdList 福利ID集合
     * @param types 福利类型集合
     * @return 福利领取数量
     */
    Map<Long, Long> findRewardCountByIdsAndTypes(List<Long> rewardIdList, List<Integer> types);

    /**
     * 批量插入，并将抽奖码变为已使用，并扣减爆款福利库存
     * @param confId 配置ID，用于爆款福利扣减库存
     * @param list 直播线索-奖励领取记录集合
     * @return 主键及用户ID
     */
    List<LiveClueRewardVisitorIdDto> batchInsertAndUseCode(Long confId, List<LiveClueRewardDto> list);

    /**
     * 提交表单资料
     *
     * @param liveClueRewardDto 奖励领取记录
     * @param formRecordDtoList 表单记录集合
     * @return true-成功 false-失败
     */
    int submitFormResource(LiveClueRewardDto liveClueRewardDto, List<FormRecordDto> formRecordDtoList);

    /**
     * 获取用户爆款领取记录
     * @param liveId 直播id
     * @param liveVisitorIdList 直播访客用户id集合
     * @param rewardType 爆款类型
     * @return key：访客用户id value：爆款福利id
     */
    Map<Long, Long> getUserBoomReceiveRecord(Long liveId, List<Long> liveVisitorIdList, Integer rewardType);

    /**
     * 根据福利记录主键id 获取发放福利的代理人的userid
     * @param id
     * @return
     */
    @Deprecated
    Long getKjjAgentUserIdById(Long id);

    /**
     * 查询领取记录代理人ID
     * @param ids 主键
     * @return key：主键，value：代理人ID
     */
    Map<Long, Long> findAgentIdMap(List<Long> ids);

    /**
     * 获取用户中奖的配置id
     * @param liveId 直播id
     * @param liveVisitorIds 直播访客用户id
     * @see RemoteLiveClueRewardService#getUserReceiveConfIds
     * @return key：直播用户id value：中奖的配置id
     */
    @Deprecated
    Map<Long, Long> getUserReceiveConfId(Long liveId, Set<Long> liveVisitorIds);

    /**
     * 获取用户中奖的配置id
     * @param liveId 直播id
     * @param liveVisitorIds 直播访客用户id
     * @return 用户在一场直播间中的多个奖品配置
     */
    Map<Long, List<Long>> getUserReceiveConfIds(Long liveId, Set<Long> liveVisitorIds);

    /**
     * 根据条件查询列表 不分页
     * @param param 查询条件
     * @return 直播用户领取记录列表
     */
    List<LiveClueRewardDto> findByCondition(LiveClueRewardSearchParam param);

    /**
     * 根据传入的福利主键集合，查询中奖数目
     * @param list
     * @return
     */
    List<LiveClueRewardConsumerParam>  findConsumerbyConfId(List<Long> list,Integer type);

    /**
     * 批量更新领取状态
     */
    int batchUpdate(List<LiveClueRewardDto> list);
}
