package cn.com.duiba.kjy.livecenter.api.dto.live.coupon;

import javax.validation.constraints.NotNull;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author xujing
 * @Date 2021/12/4 10:25 上午
 */
@Data
public class LiveCouponConfigDto implements Serializable {

    private static final long serialVersionUID = -6043756857952366675L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 发放位置 1直播间 2预约页面
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueLocationEnum
     */
    private Integer issueLocation;

    /**
     * 发放方式 1弹窗提示 2静默发放
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueWayEnum
     */
    private Integer issueWay;

    /**
     * 发放方式 1通用券 2单品券
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueTypeEnum
     */
    @NotNull(message = "发放方式不能为空")
    private Integer issueType;

    /**
     * 积分商城优惠券id
     */
    private Long couponId;

    /**
     * 每人发放几张
     */
    private Integer issueNum;

    /**
     * 1 进入直播间 2关注直播间
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponIssueUserEnum
     */
    private Integer issueUser;

    /**
     * 0 未启用 1启用 2暂停 3删除
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.coupon.CouponStatusEnum
     */
    private Integer couponStatus;

    /**
     * 面值
     */
    private Long discountAmount;

    /**
     * 使用门槛
     */
    private Long discountThreshold;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 展示json
     */
    private String showJson;

}