package cn.com.duiba.kjy.livecenter.api.dto.live.vest;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 小马甲自动评论
*/
@Data
public class LiveVestCommentAutoDto implements Serializable {

    private static final long serialVersionUID = -1176619568307523352L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 直播ID
    */
    private Long liveId;

    /**
    * 小马甲名称
    */
    private String vestName;

    /**
    * 发言方式:1-随机发言人，2-固定发言人
    */
    private Integer vestNameType;

    /**
    * 评论内容
    */
    private String commentText;

    /**
    * 评论间隔(单位/秒)
    */
    private Integer commentInterval;

    /**
    * 评论状态：1:未启用,2:启用,3:暂停
    */
    private Integer commentState;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;

}

