package cn.com.duiba.kjy.livecenter.api.enums.cardLibrary;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author xujing
 * @Date 2021/3/3 9:44 上午
 */
public enum CardTypeEnum {

    COMMON(0, "普通券"),
    LINK(1, "链接券"),
    PASSWORD(2, "卡密");

    Integer code;
    String desc;

    CardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, CardTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (CardTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static CardTypeEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
