package cn.com.duiba.kjy.livecenter.api.enums.endpage;

import cn.com.duiba.kjy.livecenter.api.util.BitUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 结束页展示标签枚举
 * @author ouyang
 * @date 2021-10-30
 **/
@AllArgsConstructor
@Getter
public enum EndPageBaseLabelEnum {

    BASE_VISITORS_NUM(0, "观看人数"),
    BASE_LIKED(1, "点赞"),
    BASE_LIVE_DURATION(2, "直播时长"),
    WELFARE_RED_AMOUNT(3, "红包金额"),
    WELFARE_PRIZE_AMOUNT(4, "奖品金额"),
    GOODS_DISPLAY(5, "商品展示心智标签")
    ;

    /**
     * 在二进制中的位置（从右往左第几位，从0开始）
     */
    private Integer position;

    /**
     * 描述
     */
    private String desc;

    /**
     * 添加标签
     * @param on 所有业务十进制值
     * @param labelEnum 要添加的标签
     * @return 添加后的所有标签十进制值
     */
    public static long addLabel(long on, EndPageBaseLabelEnum labelEnum) {
        if (labelEnum == null) {
            return on;
        }
        return BitUtils.addBit(on, labelEnum.getPosition());

    }

    /**
     * 获取标签
     * @param on 所有业务十进制值
     * @param labelEnum 要添加的标签
     * @return 添加后的所有标签十进制值
     */
    public static long getLabel(long on, EndPageBaseLabelEnum labelEnum) {
        if (labelEnum == null) {
            return on;
        }
        return BitUtils.valueOfBit(on,labelEnum.getPosition());
    }


}
