package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.HashSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2021/4/21 13:44
 */
public enum LiveInviteChannelEnum {
    /**
     * ⚠️⚠️⚠️  如果增加到用户邀请渠道属于裂变工具，请增加到下方到ACTIVITY_CHANNEL
     * 用户邀请渠道
     */
    DEFAULT(0, "默认渠道"),
    DOUBLE_RED(1, "翻倍红包"),
    FISSION_ACHIEVE(2, "裂变活动-达标必得"),
    MULTI_PRIZE(3, "裂变活动-免费抽"),
    LUCKY_RED(4, "手气王"),
    FLIP_WORD(5, "集卡"),
    BLIND_BOX(6, "抽盲盒"),
    ;
    private static final Set<LiveInviteChannelEnum> ACTIVITY_CHANNELS;


    static {
        ACTIVITY_CHANNELS = new HashSet<>();
        ACTIVITY_CHANNELS.add(FISSION_ACHIEVE);
        ACTIVITY_CHANNELS.add(MULTI_PRIZE);
        ACTIVITY_CHANNELS.add(FLIP_WORD);
        ACTIVITY_CHANNELS.add(BLIND_BOX);
    }

    /**
     * 邀请渠道是不是裂变活动
     *
     * @param inviteChannel
     * @return
     */
    public static boolean isActivityChannel(Integer inviteChannel) {
        return ACTIVITY_CHANNELS.contains(of(inviteChannel));
    }

    Integer inviteChannel;

    String desc;

    LiveInviteChannelEnum(Integer inviteChannel, String desc) {
        this.inviteChannel = inviteChannel;
        this.desc = desc;
    }

    public Integer getInviteChannel() {
        return inviteChannel;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, LiveInviteChannelEnum> ENUM_MAP = new HashMap<>();

    static {
        for (LiveInviteChannelEnum tmp : values()) {
            ENUM_MAP.put(tmp.getInviteChannel(), tmp);
        }
    }

    public static LiveInviteChannelEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }
}
