package cn.com.duiba.kjy.livecenter.api.remoteservice.cardLibrary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.cardLibrary.CardCouponLibraryDto;
import cn.com.duiba.kjy.livecenter.api.param.cardLibrary.CardLibraryPageQuery;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/3/3 10:05 上午
 */
@AdvancedFeignClient
public interface RemoteCardCouponLibraryService {
    /**
     * 插入卡券库
     *
     * @param cardCouponLibraryDto
     * @return
     */
    Long insert(CardCouponLibraryDto cardCouponLibraryDto);

    /**
     * 查询数量
     *
     * @param cardLibraryPageQuery
     * @return
     */
    Long countByParam(CardLibraryPageQuery cardLibraryPageQuery);

    /**
     * 查询列表
     *
     * @param cardLibraryPageQuery
     * @return
     */
    List<CardCouponLibraryDto> pageByParam(CardLibraryPageQuery cardLibraryPageQuery);


    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    CardCouponLibraryDto findById(Long id);

    /**
     * 删除卡券库
     * @param id
     * @return
     */
    Integer cardLibraryDelete(Long id);
}
