package cn.com.duiba.kjy.livecenter.api.remoteservice.label;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.label.LiveLabelDto;
import cn.com.duiba.kjy.livecenter.api.param.label.LiveLabelSearchParam;

import java.util.List;

/**
 * 直播标签库
 * @author chengsiyi
 * @date 2021/6/28 14:30
 */
@AdvancedFeignClient
public interface RemoteLiveLabelService {

    /**
     * 通过ID获取标签列表
     * @param ids 主键ID
     * @return 标签列表
     */
    List<LiveLabelDto> findByIds(List<Long> ids);

    /**
     * 根据条件查询标签列表
     * @param param 条件
     * @return 标签列表
     */
    List<LiveLabelDto> findByConditions(LiveLabelSearchParam param);

    /**
     * 更新/保存标签
     * @param dto 数据
     * @return 结果
     */
    int saveOrUpdate(LiveLabelDto dto);

    /**
     * 删除标签
     * @param id ID
     * @return 结果
     */
    int deleteById(Long id);
}
