package cn.com.duiba.kjy.livecenter.api.remoteservice.live;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveNewcomersDto;

/**
 * @Author xujing
 * @Date 2021/11/23 3:03 下午
 */
@AdvancedFeignClient
public interface RemoteLiveNewcomersService {


    /**
     * 根据id删除记录
     *
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 插入一条记录
     *
     * @param record
     * @return
     */
    Long insert(LiveNewcomersDto record);

    /**
     * 查询一条记录
     *
     * @param id
     * @return
     */
    LiveNewcomersDto selectById(Long id);

    /**
     * 更新一条记录
     *
     * @param record
     * @return
     */
    int updateById(LiveNewcomersDto record);


    /**
     * 根据直播id
     * @param liveId
     * @return
     */
    LiveNewcomersDto findByLiveId(Long liveId);


}
