package cn.com.duiba.kjy.livecenter.api.remoteservice.live.coupon;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.coupon.LiveCouponConfigDto;
import cn.com.duiba.kjy.livecenter.api.param.live.share.coupon.LiveCouponSearchParams;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/12/4 10:25 上午
 */
@AdvancedFeignClient
public interface RemoteLiveCouponConfigService {

    /**
     * 新增一条记录
     * @param record
     * @return
     */
    Long insert(LiveCouponConfigDto record);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    LiveCouponConfigDto selectById(Long id);

    /**
     * 根据id更新
     * @param record
     * @return
     */
    int updateById(LiveCouponConfigDto record);


    /**
     * 查询直播间优惠券配置列表
     * @param liveId
     * @return
     */
    List<LiveCouponConfigDto> listByLiveId(Long liveId);


    /**
     * 根据直播间id和优惠券id查询
     * @param liveId
     * @param couponId
     * @return
     */
    LiveCouponConfigDto findByLiveIdAndCouponId(Long liveId,Long couponId);


    /**
     * 批量更新
     * @param liveCouponConfigDtos
     * @return
     */
    int updateBatchSelective(List<LiveCouponConfigDto> liveCouponConfigDtos);

    /**
     * 根据直播间ids查询
     * @param ids
     * @return
     */
    List<LiveCouponConfigDto> listByIds(List<Long> ids);

    /**
     * 根据params查询
     * @param couponSearchParam
     * @return
     */
    List<LiveCouponConfigDto> listByParams(LiveCouponSearchParams couponSearchParam);


}
