package cn.com.duiba.kjy.livecenter.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveclue.LiveClueReplyAdviceNewDto;

import java.util.List;

/**
 * 回复建议
 *
 * @author xuzhigang
 * @date 2020/8/31 5:15 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveClueReplyAdviceNewService {
    /**
     * 更新回复建议
     * @param updateDtoList 回复建议集合
     * @return 更新结果
     */
    int batchUpdateReplyAdvice(List<LiveClueReplyAdviceNewDto> updateDtoList);

    /**
     * 根据模板id查询回复建议列表
     *
     * @param templateId 模板id
     * @return 回复建议集合
     */
    List<LiveClueReplyAdviceNewDto> selectListByTemplateId(Long templateId);
}
