package cn.com.duiba.kjy.livecenter.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author xujing
 * @Date 2021/10/14 10:45 上午
 */
@Data
public class DuibaOrderBean implements Serializable {

    private static final long serialVersionUID = -3879462733277820417L;
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 应用id
     */
    private Long appId;

    /**
    * 订单id
    */
    private Long orderId;

    /**
    * 订单号
    */
    private String orderNum;

    /**
    * 订单创建时间
    */
    private Date orderCreateTime;

    /**
    * 用户id
    */
    private String userId;

    /**
    * 商品id
    */
    private Long goodsId;

    /**
    * 商品名称
    */
    private String goodsTitle;

    /**
    * 商品金额
    */
    private Long totalAmount;

    /**
    * 实付金额
    */
    private Long realPayAmount;

    /**
    * 支付方式
    */
    private String payWay;

    /**
     * 支付银行
     */
    private String payBank;

    /**
    * 支付时间
    */
    private Date paidTime;

    /**
    * 订单状态
    */
    private String orderStatus;

    /**
    * 订单完成时间
    */
    private Date finishTime;

    /**
    * 1 初始化 2 第三方收单失败 3 第三方收单成功 4 退款成功 5 退款失败
    */
    private Integer refundStatus;

    /**
    * 退款时间
    */
    private Date refundTime;

    /**
    * 退款金额
    */
    private Long refundAmount;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;
}