package cn.com.duiba.kjy.livecenter.api.dto.smallshop;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 *
 * @author fss
 * @date 2021/9/06
 */
@Data
@ToString
public class AuthorizerTokenDto implements Serializable {

	private static final long serialVersionUID = -5383811762650207953L;
	/**
	 * 网页授权接口调用凭证
	 */
	@JSONField( name = "access_token" )
	private String accessToken;

	/**
	 * access_token接口调用凭证超时时间，单位（秒）
	 */
	@JSONField( name = "expire_in" )
	private Integer expireIn;

	/**
	 * 用户刷新access_token
	 */
	@JSONField( name = "refresh_token" )
	private String refreshToken;

	/**
	 * 当前微店用户（店铺）id
	 */
	@JSONField( name = "openid" )
	private String openid;

	/**
	 * 当前微店用户的店铺名称
	 */
	@JSONField( name = "shop_name" )
	private String shopName;

	/**
	 * 用户授权的作用域，使用逗号（,）分隔
	 */
	@JSONField( name = "scope" )
	private Integer scope;

	/**
	 * 当前微店用户的店铺logo
	 */
	@JSONField( name = "shop_logo" )
	private String shopLogo;
}
