package cn.com.duiba.kjy.livecenter.api.dto.subscribe;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by hong
 * time 2021/12/17.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class WxSubscribeMessageDto implements Serializable {

    private static final long serialVersionUID = -732960534285696151L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务ID   根据push_type取那张表的id
     */
    private Long bizId;

    /**
     * 推送类型 1-优惠券使用提醒
     * @see cn.com.duiba.kjy.livecenter.api.enums.subscribe.MessagePushTypeEnum
     */
    private Integer pushType;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录修改时间
     */
    private Date gmtModified;

    /**
     * 推送业务id 类型为1对应tb_live.id
     */
    private Long pushBizId;

    /**
     * 直播用户id（tb_live_user.id）
     */
    private Long liveUserId;

    /**
     * 推送剩余次数
     */
    private Integer pushRemainTimes;

    /**
     * 推送额外参数
     */
    private String extraParams;
}
