package cn.com.duiba.kjy.livecenter.api.param.invitation;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 社群邀请关系
 * @author ouyang
 * @date 2022-05-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class CommunityInvitationSearchParam extends PageQuery {


    private static final long serialVersionUID = -8985301320299498774L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 邀约状态
     * @see cn.com.duiba.kjy.livecenter.api.enums.invitation.CommunityInvitationStatusEnum
     */
    private Integer inviteStatus;

    /**
     * 业务来源
     */
    private String bizSource;

    /**
     * 邀请渠道id
     */
    private Long drainageId;

    /**
     * 邀请人直播用户ID
     */
    private Long inviterId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 邀请链路，以英文逗号分隔
     */
    private String inviterIds;

}
