package cn.com.duiba.kjy.livecenter.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.black.LiveBlackSourceDto;
import cn.com.duiba.kjy.livecenter.api.param.black.LiveBlackSourceSearchParam;

import java.util.List;

/**
 * 黑名单用户来源rpc接口
 * @author 吴文哲
 * @date 2020-09-27 15:25
 **/
@AdvancedFeignClient
public interface RemoteLiveBlackSourceService {

    /**
     * 根据条件统计数量
     * @param searchParam 查询条件
     * @return 总数
     */
    long countByCondition(LiveBlackSourceSearchParam searchParam);

    /**
     * 根据条件查询列表
     * @param searchParam 直播黑名单源头查询参数
     * @return 黑名单源头列表
     */
    List<LiveBlackSourceDto> findByCondition(LiveBlackSourceSearchParam searchParam);

    /**
     * 根据条件累计封禁人数
     * @param param 查询条件
     * @return 封禁人数
     */
    Long sumBanNum(LiveBlackSourceSearchParam param);


    /**
     * 批量插入
     * @param insertList 待插入的直播黑名单来源列表
     * @return 影响行数
     */
    int batchInsertBlackSource(List<LiveBlackSourceDto> insertList);

    /**
     * 根据直播用户id查询 这些用户是否已经存在
     * @param liveUserIds 直播用户列表id
     * @return 返回存在的用户id列表
     */
    List<Long> findExistsUserIds(List<Long> liveUserIds,Integer sourceType);


    /**
     * 根据主键查询
     * @param id 主键id
     * @return 直播黑名单源头用户对象
     */
    LiveBlackSourceDto findById(Long id);

    /**
     * 根据主键ids查询列表
     * @param ids 主键id列表
     * @return 直播黑名单源头用户列表
     */
    List<LiveBlackSourceDto> findByIds(List<Long> ids);

    /**
     * 根据直播用户id 删除黑名单源头数据
     *
     * @param liveUserId 直播用户id
     * @return 删除结果
     */
    boolean delBlackSource(Long liveUserId);
}
