package cn.com.duiba.kjy.livecenter.api.remoteservice.creditCard;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.conf.CardHolderConfigDto;
import cn.com.duiba.kjy.livecenter.api.dto.creditCard.LiveCardHolderDto;
import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderStatusEnum;
import cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum;
import java.util.List;
import java.util.Map;

/**
 * @author chenhang
 * @date 2022/1/13 11:28 上午
 */
@AdvancedFeignClient
public interface RemoteLiveCardHolderService {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    LiveCardHolderDto findById(Long id);

    /**
     * 新增或者更新数据
     *
     * @param liveCardHolderDto 实例对象
     * @return 影响的行数
     */
    int saveOrUpdate(LiveCardHolderDto liveCardHolderDto);

    /**
     * 根据类型获取用户持卡状态
     * @param liveUserId 用户id
     * @param cardHolderType 持卡类型
     * @see  CardHolderTypeEnum
     * @see  CardHolderStatusEnum
     * @return 用户持卡状态
     */
    LiveCardHolderDto getByLiveUserIdAndType(Long liveUserId,Integer cardHolderType);

    /**
     * 根据类型获取用户持卡状态
     * @param liveUserId 用户id
     * @param cardHolderType 持卡类型
     * @see  CardHolderTypeEnum
     * @see  CardHolderStatusEnum
     * @return 用户持卡状态
     */
    Integer getStatusByLiveUserIdAndType(Long liveUserId,Integer cardHolderType);

    /**
     * 根据类型获取用户持卡状态
     * @param liveUserId 用户id
     * @param companyId 公司id
     * @return 用户持卡信息
     */
    LiveCardHolderDto getByLiveUserIdAndCompanyId(Long liveUserId,Long companyId);

    /**
     * 根据类型获取用户持卡状态
     * @param liveUserId 用户id
     * @param companyId 公司id
     * @return 用户持卡状态
     */
    Integer getStatusByLiveUserIdAndCompanyId(Long liveUserId,Long companyId);

    /**
     * 批量获取用户持卡信息
     * @param liveUserIds 用户id
     * @param companyIds 公司id列表
     * @return key 直播id value 持卡状态
     */
    List<LiveCardHolderDto> batchGetByLiveUserIdsAndCompanyIds(List<Long> liveUserIds, List<Long> companyIds);

    /**
     * 根据公司id获取持卡类型
     * @param companyId 公司id
     * @return 持卡类型
     */
    CardHolderConfigDto getConfigByCompanyId(Long companyId);

    /**
     * 获取持卡配置
     * @return 配置信息
     */
    Map<Long, CardHolderConfigDto> getCardHolderConfig();

    /**
     * 查询指定公司、指定持卡类型中已持卡的用户列表
     *
     * @param liveUserIds 直播用户Id列表
     * @param holdType    持卡类型
     *                    {@link cn.com.duiba.kjy.livecenter.api.enums.creditCard.CardHolderTypeEnum}
     * @param companyId   公司Id
     * @return 用户持卡情况列表
     */
    List<LiveCardHolderDto> listAlreadyHold(List<Long> liveUserIds, Integer holdType, Long companyId);

}
