package cn.com.duiba.kjy.livecenter.api.remoteservice.live.vest;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.vest.LiveVestCommentAutoDto;

import java.util.List;

/**
 * 直播小马甲自动评论
 * @author ouyang
 * @date 2021/9/22
 */
@AdvancedFeignClient
public interface RemoteLiveVestCommentAutoService {



    /**
     * 根据主键查询
     * @param id 主键
     * @return 小马甲评论信息
     */
    LiveVestCommentAutoDto selectById(Long id);

    /**
     * 根据直播Id查询评论列表
     * @param liveId 直播ID
     * @return 小马甲评论信息
     */
    List<LiveVestCommentAutoDto> selectByLiveId(Long liveId);

    /**
     * 新增/编辑
     * @param dto 小马甲评论信息
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveVestCommentAutoDto dto);

    /**
     * 逻辑删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

}
