package cn.com.duiba.kjy.livecenter.api.dto.invitation;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 社群邀请关系
 * @author ouyang
 * @date 2022-05-26
 */
@Data
public class CommunityInvitationDto implements Serializable {

    private static final long serialVersionUID = -3514823632000507686L;


    /**
     * 主键
     */
    private Long id;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 业务来源
     */
    private String bizSource;

    /**
     * 邀约状态 1.邀约关系 2.确认
     */
    private Integer inviteStatus;

    /**
     * 邀请渠道id
     */
    private Long drainageId;

    /**
     * 邀请人用户ID
     */
    private Long inviterId;

    /**
     * 访客用户ID
     */
    private Long liveVisitorId;

    /**
     * 邀请链路，以英文逗号分隔
     */
    private String inviterIds;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
