package cn.com.duiba.kjy.livecenter.api.dto.live.goods;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Created by hong
 * time 2021/6/1.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AppointmentGoodsDto implements Serializable {

    private static final long serialVersionUID = -8147396368296544446L;

    /**
     * 商品id
     */
    private Long id;

    /**
     * 配置id
     */
    private Long configId;

    /**
     * 商品名称
     */
    private String goodName;

    /**
     * 图片
     */
    private String goodImg;

    /**
     * 权益
     */
    private String goodRight;

    /**
     * 数量
     */
    private Integer goodNum;

    /**
     * 价格
     */
    private Integer goodPrice;

    /**
     * 原价格
     */
    private String originalPrice;

    /**
     * 是否已选择
     */
    private Boolean selected;

    /**
     * 爆款销量
     */
    private Integer boomSales;

    /**
     * 是否已预约
     */
    private Boolean appointed;

    /**
     * 剩余库存
     */
    private Integer remainGoodNum;


    /**
     * 商品折扣
     */
    private Double productDiscount;

    /**
     * 卡片名称
     */
    private String cardName;

    /**
     * 减免金额
     */
    private Integer reduceAmount;

    /**
     * 营销类别：1-普通商品2-半价商品 3-免费抢 4-半价抽 5-活动商品 6-售卖商品
     */
    private Integer marketType;

    /**
     * 营销标签配图
     */
    private String marketLabelImg;
}
